/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.event;

import com.redpxnda.respawnobelisks.config.CurseConfig;
import com.redpxnda.respawnobelisks.config.ObeliskCoreConfig;
import com.redpxnda.respawnobelisks.config.ReviveConfig;
import com.redpxnda.respawnobelisks.config.TeleportConfig;
import com.redpxnda.respawnobelisks.config.TrustedPlayersConfig;
import com.redpxnda.respawnobelisks.data.listener.ObeliskCore;
import com.redpxnda.respawnobelisks.data.listener.ObeliskInteraction;
import com.redpxnda.respawnobelisks.data.saved.AnchorExplosions;
import com.redpxnda.respawnobelisks.data.saved.RuneCircles;
import com.redpxnda.respawnobelisks.network.ModPackets;
import com.redpxnda.respawnobelisks.network.SyncEffectsPacket;
import com.redpxnda.respawnobelisks.registry.ModRegistries;
import com.redpxnda.respawnobelisks.registry.block.RespawnObeliskBlock;
import com.redpxnda.respawnobelisks.registry.block.entity.RespawnObeliskBlockEntity;
import com.redpxnda.respawnobelisks.registry.item.BoundCompassItem;
import com.redpxnda.respawnobelisks.registry.structure.VillageAddition;
import com.redpxnda.respawnobelisks.util.CoreUtils;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.utils.value.IntValue;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CommonEvents {
    public static EventResult onBlockInteract(Player player, InteractionHand hand, BlockPos pos, Direction face) {
        if (!(hand.equals((Object)InteractionHand.MAIN_HAND) && player.m_21205_().m_150930_(Items.f_220211_) && player.m_9236_().m_8055_(pos).m_60713_(Blocks.f_50729_))) {
            return EventResult.pass();
        }
        if (TeleportConfig.enableTeleportation) {
            player.m_21008_(hand, new ItemStack((ItemLike)ModRegistries.BOUND_COMPASS.get()));
        }
        BlockHitResult hitResult = new BlockHitResult(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), face, pos, false);
        Item item = player.m_21120_(hand).m_41720_();
        if (item instanceof BoundCompassItem) {
            BoundCompassItem item2 = (BoundCompassItem)item;
            item2.m_6225_(new UseOnContext(player, hand, hitResult));
        }
        return EventResult.pass();
    }

    public static EventResult onBreakBlock(Level level, BlockPos pos, BlockState state, ServerPlayer player, @Nullable IntValue xp) {
        if (player.m_150110_().f_35937_) {
            return EventResult.pass();
        }
        if (state.m_60734_() instanceof RespawnObeliskBlock) {
            BlockEntity blockEntity;
            if (((DoubleBlockHalf)state.m_61143_(RespawnObeliskBlock.HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
                pos = pos.m_7495_();
            }
            if ((blockEntity = level.m_7702_(pos)) instanceof RespawnObeliskBlockEntity) {
                RespawnObeliskBlockEntity blockEntity2 = (RespawnObeliskBlockEntity)blockEntity;
                if (!TrustedPlayersConfig.allowObeliskBreaking && !blockEntity2.isPlayerTrusted(player.m_6302_()) || blockEntity2.hasStoredItems && !player.m_6144_() || !blockEntity2.getItemStack().m_41619_() && !player.m_6144_() || blockEntity2.hasTeleportingEntity) {
                    return EventResult.interruptFalse();
                }
            }
        }
        return EventResult.pass();
    }

    public static EventResult onEntityInteract(Player player, Entity entity, InteractionHand hand) {
        ResourceLocation rl;
        if (player.f_19853_.f_46443_ || !hand.equals((Object)InteractionHand.MAIN_HAND) || !ObeliskCore.CORES.containsKey(rl = Registry.f_122827_.m_7981_((Object)player.m_21205_().m_41720_())) || player.m_36335_().m_41519_(player.m_21205_().m_41720_())) {
            return EventResult.pass();
        }
        ObeliskCore.Instance core = new ObeliskCore.Instance(player.m_21205_(), ObeliskCore.CORES.get(rl));
        ItemStack stack = core.stack();
        if (!stack.m_41784_().m_128441_("RespawnObeliskData")) {
            stack.m_41783_().m_128365_("RespawnObeliskData", (Tag)new CompoundTag());
        }
        if (ReviveConfig.enableRevival && CoreUtils.hasInteraction(core, ObeliskInteraction.REVIVE) && !(entity instanceof Player) && entity instanceof LivingEntity && ReviveConfig.isEntityListed(entity)) {
            ListTag listTag;
            if (!stack.m_41783_().m_128469_("RespawnObeliskData").m_128441_("SavedEntities")) {
                stack.m_41783_().m_128469_("RespawnObeliskData").m_128365_("SavedEntities", (Tag)new ListTag());
            }
            if ((listTag = stack.m_41783_().m_128469_("RespawnObeliskData").m_128437_("SavedEntities", 10)).size() >= ObeliskCoreConfig.maxStoredEntities) {
                return EventResult.pass();
            }
            if (!CommonEvents.containsUUID(listTag, entity.m_20148_())) {
                CompoundTag entityTag = new CompoundTag();
                entityTag.m_128362_("uuid", entity.m_20148_());
                entityTag.m_128359_("type", Registry.f_122826_.m_7981_((Object)entity.m_6095_()).toString());
                entityTag.m_128365_("data", (Tag)new CompoundTag());
                entityTag.m_128469_("data").m_128359_("DeathLootTable", "minecraft:empty");
                entity.m_20240_(entityTag.m_128469_("data"));
                if (!listTag.contains((Object)entityTag)) {
                    listTag.add((Object)entityTag);
                    player.m_36335_().m_41524_(stack.m_41720_(), 100);
                    return EventResult.interruptFalse();
                }
            } else {
                CommonEvents.removeUUID(listTag, entity.m_20148_());
                player.m_36335_().m_41524_(stack.m_41720_(), 100);
            }
        }
        if (TrustedPlayersConfig.enablePlayerTrust && entity instanceof Player) {
            Player interacted = (Player)entity;
            if (CoreUtils.hasInteraction(core, ObeliskInteraction.PROTECT)) {
                ListTag listTag;
                if (!stack.m_41783_().m_128469_("RespawnObeliskData").m_128441_("TrustedPlayers")) {
                    stack.m_41783_().m_128469_("RespawnObeliskData").m_128365_("TrustedPlayers", (Tag)new ListTag());
                }
                if (!(listTag = stack.m_41783_().m_128469_("RespawnObeliskData").m_128437_("TrustedPlayers", 8)).contains((Object)StringTag.m_129297_((String)interacted.m_6302_()))) {
                    listTag.add((Object)StringTag.m_129297_((String)interacted.m_6302_()));
                    if (!listTag.contains((Object)StringTag.m_129297_((String)player.m_6302_()))) {
                        listTag.add((Object)StringTag.m_129297_((String)player.m_6302_()));
                    }
                    player.m_36335_().m_41524_(stack.m_41720_(), 100);
                    return EventResult.interruptFalse();
                }
                listTag.remove((Object)StringTag.m_129297_((String)interacted.m_6302_()));
                if (!listTag.contains((Object)StringTag.m_129297_((String)player.m_6302_()))) {
                    listTag.add((Object)StringTag.m_129297_((String)player.m_6302_()));
                }
                player.m_36335_().m_41524_(stack.m_41720_(), 100);
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    private static boolean containsUUID(ListTag tag, UUID uuid) {
        for (Tag value : tag) {
            CompoundTag compound;
            if (!(value instanceof CompoundTag) || !(compound = (CompoundTag)value).m_128342_("uuid").equals(uuid)) continue;
            return true;
        }
        return false;
    }

    private static void removeUUID(ListTag tag, UUID uuid) {
        tag.removeIf(t -> {
            CompoundTag compound;
            return t instanceof CompoundTag && (compound = (CompoundTag)t).m_128342_("uuid").equals(uuid);
        });
    }

    public static void onPlayerClone(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean wonGame) {
        BlockEntity blockEntity;
        if (wonGame) {
            return;
        }
        if (oldPlayer.m_21023_((MobEffect)ModRegistries.IMMORTALITY_CURSE.get())) {
            CommonEvents.cloneAddCurse(newPlayer, oldPlayer);
        }
        if (oldPlayer.m_8961_() != null && (blockEntity = oldPlayer.f_19853_.m_7702_(oldPlayer.m_8961_())) instanceof RespawnObeliskBlockEntity) {
            RespawnObeliskBlockEntity be = (RespawnObeliskBlockEntity)blockEntity;
            be.restoreSavedItems((Player)newPlayer);
        }
    }

    private static void cloneAddCurse(ServerPlayer newPlayer, ServerPlayer oldPlayer) {
        MobEffectInstance MEI = oldPlayer.m_21124_((MobEffect)ModRegistries.IMMORTALITY_CURSE.get());
        if (MEI == null) {
            return;
        }
        int amplifier = MEI.m_19564_();
        if (amplifier == CurseConfig.curseMaxLevel + 1) {
            amplifier = -1;
        }
        amplifier = Math.min(amplifier + CurseConfig.curseLevelIncrement, CurseConfig.curseMaxLevel - 1);
        newPlayer.m_7292_(new MobEffectInstance(MEI.m_19544_(), CurseConfig.curseDuration, amplifier));
    }

    public static void onPlayerRespawn(ServerPlayer player, boolean conqueredEnd) {
        if (player.m_21023_((MobEffect)ModRegistries.IMMORTALITY_CURSE.get())) {
            MobEffectInstance MEI = player.m_21124_((MobEffect)ModRegistries.IMMORTALITY_CURSE.get());
            if (MEI == null) {
                return;
            }
            ModPackets.CHANNEL.sendToPlayer(player, (Object)new SyncEffectsPacket(MEI.m_19564_(), MEI.m_19557_()));
        }
    }

    public static void onServerTick(ServerLevel level) {
        RuneCircles.getCache(level).tick();
        AnchorExplosions.getCache(level).tick();
    }

    public static void init() {
        LifecycleEvent.SERVER_BEFORE_START.register(VillageAddition::addNewVillageBuilding);
        TickEvent.SERVER_LEVEL_POST.register(CommonEvents::onServerTick);
        PlayerEvent.PLAYER_CLONE.register(CommonEvents::onPlayerClone);
        PlayerEvent.PLAYER_RESPAWN.register(CommonEvents::onPlayerRespawn);
        InteractionEvent.INTERACT_ENTITY.register(CommonEvents::onEntityInteract);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(CommonEvents::onBlockInteract);
        BlockEvent.BREAK.register(CommonEvents::onBreakBlock);
    }
}

